unit Fdemo20;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  StdCtrls, Forms, DBCtrls, DB, Buttons, ExtCtrls, DBTables, Mask, PrnWin,
  CB_Types, DBPrnWin, CB_MFunc;

type
  TForm20 = class(TForm)
    ScrollBox: TScrollBox;
    Label1: TLabel;
    EditCustNo: TDBEdit;
    Label2: TLabel;
    EditCompany: TDBEdit;
    Label3: TLabel;
    EditAddr: TDBEdit;
    Label4: TLabel;
    EditAddr2: TDBEdit;
    Label5: TLabel;
    EditCity: TDBEdit;
    Label6: TLabel;
    EditState: TDBEdit;
    Label7: TLabel;
    EditZip: TDBEdit;
    Label8: TLabel;
    EditCountry: TDBEdit;
    DBNavigator: TDBNavigator;
    Panel1: TPanel;
    DataSource1: TDataSource;
    Panel2: TPanel;
    Query1: TQuery;
    Panel3: TPanel;
    ScrollBox1: TScrollBox;
    Label14: TLabel;
    Shape1: TShape;
    Label18: TLabel;
    Label19: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label20: TLabel;
    Image1: TImage;
    Memo5: TMemo;
    Memo6: TMemo;
    Memo7: TMemo;
    Edit1: TEdit;
    Preview: TBitBtn;
    PrintAll: TBitBtn;
    Print3: TBitBtn;
    Exit: TBitBtn;
    Panel4: TPanel;
    Panel5: TPanel;
    DBEdit2: TDBEdit;
    DBEdit3: TDBEdit;
    DBEdit4: TDBEdit;
    DBEdit5: TDBEdit;
    DBEdit6: TDBEdit;
    DBEdit7: TDBEdit;
    DBEdit8: TDBEdit;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    DBEdit1: TDBEdit;
    Label12: TLabel;
    DBEdit9: TDBEdit;
    DBEdit10: TDBEdit;
    Label15: TLabel;
    DBEdit11: TDBEdit;
    Label16: TLabel;
    DBEdit12: TDBEdit;
    Label17: TLabel;
    DBEdit13: TDBEdit;
    Label21: TLabel;
    DBEdit14: TDBEdit;
    Label13: TLabel;
    DBEdit15: TDBEdit;
    Label22: TLabel;
    DBPrintWin1: TDBPrintWin;
    procedure FormCreate(Sender: TObject);
    procedure PreviewClick(Sender: TObject);
    procedure ExitClick(Sender: TObject);
    procedure Print3Click(Sender: TObject);
    procedure PrintAllClick(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form20: TForm20;

implementation

{$R *.DFM}

procedure TForm20.FormCreate(Sender: TObject);
begin
  Query1.Open;
end;

{ Preview/Print current Record }
procedure TForm20.PreviewClick(Sender: TObject);
begin
	ScrollBox1.VertScrollBar.Position := 0;
	ScrollBox1.HorzScrollBar.Position := 0;
	DBPrintWin1.BeginPrint;
   DBPrintWin1.DrawWindowAt( 0.75, 1.0, ScrollBox1);
	DBPrintWin1.EndPrint;

end;

procedure TForm20.ExitClick(Sender: TObject);
begin
	Close;
end;

{ Print all Records from Query}
{ Print next 3 Records from Query}
procedure TForm20.Print3Click(Sender: TObject);
var
	Bookmark: TBookmark;
   i: Integer;
begin
	{ Make sure the scrollbox is at the top }
	ScrollBox1.VertScrollBar.Position := 0;
	ScrollBox1.HorzScrollBar.Position := 0;

   { Set PrintWin to the printer }
	DBPrintWin1.OutputTo := poPrinter;


	{ Mark the current record }
   Bookmark := Query1.GetBookmark;

   { Print next 3 records }
   for i := 1 to 3 do begin
		DBPrintWin1.BeginPrint;
   	DBPrintWin1.DrawWindowAt( 0.75, 1.0, ScrollBox1);
		DBPrintWin1.EndPrint;
      Query1.Next;
   end;

   { Return to original record and free the bookmark}
   Query1.GotoBookmark (Bookmark);
   Query1.FreeBookmark (Bookmark);

   { Reset to print to the Viewer }
	DBPrintWin1.OutputTo := poViewer;

end;

procedure TForm20.PrintAllClick(Sender: TObject);
var
	Bookmark: TBookmark;
   i: Integer;
begin
	{ Make sure the scrollbox is at the top }
	ScrollBox1.VertScrollBar.Position := 0;
	ScrollBox1.HorzScrollBar.Position := 0;

   { Set PrintWin to the printer }
	DBPrintWin1.OutputTo := poPrinter;


	{ Mark the current record }
   Bookmark := Query1.GetBookmark;

   { Go to the first record }
   Query1.First;


   { Print all records }
   while not Query1.Eof do begin
		DBPrintWin1.BeginPrint;
   	DBPrintWin1.DrawWindowAt( 0.75, 1.0, ScrollBox1);
		DBPrintWin1.EndPrint;
      Query1.Next;
   end;

   { Return to original record and free the bookmark}
   Query1.GotoBookmark (Bookmark);
   Query1.FreeBookmark (Bookmark);

   { Reset to print to the Viewer }
	DBPrintWin1.OutputTo := poViewer;
end;

end.